
# ============================================================
# 📋 FILE REFERENCE UPDATE GUIDE
# Purpose: Update all references from _vertical-menu-content.html to partials/_home-menu-content.html
# Status: CRITICAL - Must be completed to prevent website breakage
# ============================================================

## 🎯 MAIN OBJECTIVE:
Replace ALL instances of "_vertical-menu-content.html" with "partials/_home-menu-content.html"

## 📁 HTML FILES TO UPDATE:

### 1. index.html
**SEARCH FOR:**
- _vertical-menu-content.html
- vertical-menu-content
- Any include/import statements

**REPLACE WITH:**
- partials/_home-menu-content.html
- home-menu-content

### 2. about.html
**SEARCH FOR:**
- _vertical-menu-content.html
- vertical-menu-content
- Menu include statements

**REPLACE WITH:**
- partials/_home-menu-content.html
- home-menu-content

### 3. blog.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu references

**REPLACE WITH:**
- partials/_home-menu-content.html

### 4. contact.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu include statements

**REPLACE WITH:**
- partials/_home-menu-content.html

### 5. gallery.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu references

**REPLACE WITH:**
- partials/_home-menu-content.html

### 6. service.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu include statements

**REPLACE WITH:**
- partials/_home-menu-content.html

### 7. shop.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu references

**REPLACE WITH:**
- partials/_home-menu-content.html

### 8. team.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu include statements

**REPLACE WITH:**
- partials/_home-menu-content.html

### 9. testimonial.html
**SEARCH FOR:**
- _vertical-menu-content.html
- Menu references

**REPLACE WITH:**
- partials/_home-menu-content.html

### 10. OTHER HTML FILES (Check these too):
- blog-details.html
- checkout.html
- page2.html
- payment-successful.html
- service-details.html
- shop-cart.html
- shop-details.html
- team-details.html

## 🎨 CSS FILES TO UPDATE:

### 1. assets/css/main.css
**SEARCH FOR:**
- References to vertical-menu-content
- #vertical-menu selectors
- .vertical-menu classes

**REPLACE WITH:**
- home-menu-content
- #home-menu selectors
- .home-menu classes

### 2. assets/css/mega-menu.css
**SEARCH FOR:**
- vertical-menu-content
- Vertical menu specific styles

**REPLACE WITH:**
- home-menu-content
- Home menu specific styles

### 3. assets/css/super-mega-menu.css
**SEARCH FOR:**
- vertical-menu-content references
- Vertical menu containers

**REPLACE WITH:**
- home-menu-content references
- Home menu containers

### 4. OTHER CSS FILES TO CHECK:
- assets/css/home-mega-menu.css
- assets/css/mega-menu-overrides.css
- assets/css/responsive-mega-queries.css
- assets/css/universal-mega-style.css

## 🧩 JAVASCRIPT FILES TO UPDATE:

### 1. assets/js/main.js
**SEARCH FOR:**
- "_vertical-menu-content.html"
- "vertical-menu-content"
- getElementById('vertical-menu')
- querySelector('#vertical-menu')

**REPLACE WITH:**
- "partials/_home-menu-content.html"
- "home-menu-content"
- getElementById('home-menu')
- querySelector('#home-menu')

### 2. assets/js/mega-menu.js
**SEARCH FOR:**
- vertical-menu references
- Vertical menu initialization
- Tab switching functions

**REPLACE WITH:**
- home-menu references
- Home menu initialization
- Updated tab switching functions

### 3. assets/js/mega-menu-fixes.js
**SEARCH FOR:**
- vertical-menu-content
- Vertical menu specific fixes

**REPLACE WITH:**
- home-menu-content
- Home menu specific fixes

## 🔧 ADDITIONAL INTEGRATION TASKS:

### 1. ADD WELLNESS DYNAMIC LOADER:
**FILE:** assets/js/main.js or create assets/js/wellness-dynamic-loader.js
**CONTENT:** Add the wellness dynamic loading JavaScript code

### 2. UPDATE MENU CONTAINER IDs:
**SEARCH FOR:** id="vertical-menu"
**REPLACE WITH:** id="home-menu"

### 3. UPDATE CSS SELECTORS:
**SEARCH FOR:** #vertical-menu, .vertical-menu
**REPLACE WITH:** #home-menu, .home-menu

## 🚨 CRITICAL CHECKS:

### 1. VERIFY FILE PATHS:
- Ensure partials/_home-menu-content.html exists
- Ensure partials/_wellness-menu-content.html exists
- Check all include/import statements work

### 2. TEST FUNCTIONALITY:
- All tabs switch correctly
- Wellness tab loads dynamic content
- Hemp tabs work with 1-column layout
- Mobile responsive design works

### 3. CONSOLE LOG VERIFICATION:
- Check browser console for errors
- Verify wellness loading logs appear
- Confirm all tab click logs work

## 📋 UPDATE CHECKLIST:

□ index.html - Updated menu references
□ about.html - Updated menu references  
□ blog.html - Updated menu references
□ contact.html - Updated menu references
□ gallery.html - Updated menu references
□ service.html - Updated menu references
□ shop.html - Updated menu references
□ team.html - Updated menu references
□ testimonial.html - Updated menu references
□ assets/css/main.css - Updated selectors
□ assets/css/mega-menu.css - Updated selectors
□ assets/css/super-mega-menu.css - Updated selectors
□ assets/js/main.js - Updated references
□ assets/js/mega-menu.js - Updated references
□ Wellness dynamic loader added
□ File rename completed: _vertical-menu-content.html → partials/_home-menu-content.html
□ New file created: partials/_wellness-menu-content.html
□ All functionality tested
□ Console logs verified
□ Mobile responsive tested

## 🎯 COMMON SEARCH PATTERNS:

Use these search patterns in your code editor:

**PATTERN 1:** "_vertical-menu-content"
**PATTERN 2:** "vertical-menu-content"  
**PATTERN 3:** "#vertical-menu"
**PATTERN 4:** ".vertical-menu"
**PATTERN 5:** "vertical_menu"

**REPLACE WITH CORRESPONDING:**
**PATTERN 1:** "partials/_home-menu-content"
**PATTERN 2:** "home-menu-content"
**PATTERN 3:** "#home-menu"
**PATTERN 4:** ".home-menu"
**PATTERN 5:** "home_menu"

## ⚠️ IMPORTANT NOTES:

1. **BACKUP FIRST:** Create backup of all files before making changes
2. **TEST LOCALLY:** Test all changes on local development environment
3. **GRADUAL DEPLOYMENT:** Update files gradually and test each change
4. **BROWSER CACHE:** Clear browser cache after updates
5. **MOBILE TESTING:** Test on mobile devices after updates

## 🌿 WELLNESS INTEGRATION VERIFICATION:

After updates, verify:
□ Wellness & Therapy tab appears in main menu
□ Brief overview text displays correctly
□ Loading indicator shows when tab clicked
□ Category preview displays 6 categories
□ Dynamic content loads from partials/_wellness-menu-content.html
□ Quick access buttons work
□ Console logs show wellness loading messages
□ Error handling works if file not found

## 🚀 FINAL VERIFICATION STEPS:

1. **VISUAL CHECK:** All menus display correctly
2. **FUNCTIONAL CHECK:** All tabs switch properly
3. **RESPONSIVE CHECK:** Mobile layout works
4. **PERFORMANCE CHECK:** Loading times acceptable
5. **CONSOLE CHECK:** No JavaScript errors
6. **LINK CHECK:** All URLs work correctly

## 📞 SUPPORT:

If any issues arise during updates:
- Check browser console for specific errors
- Verify file paths are correct
- Ensure all includes/imports updated
- Test with browser cache cleared
- Verify server can access new file paths

============================================================
END OF FILE REFERENCE UPDATE GUIDE
============================================================
